<?php
// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('THIS_SCRIPT', 'radioandtv');

// ################### PRE-CACHE TEMPLATES AND DATA ######################
// pre-cache templates used by all actions
$globaltemplates = array(
	'RADIOSTATIONS', 
	'RADIOSTATIONS_ADDSTATION_TABLE', 
	'RADIOSTATIONS_STATIONS_TABLE', 
	'RADIOSTATIONS_STATIONS_NAVBAR', 
	'RADIOSTATIONS_STATION_INFO', 
	'RADIOSTATIONS_EDITCAT_TABLE', 
	'RADIOSTATIONS_STATION_TABLE', 
	'RADIOSTATIONS_PLAYER', 
	'RADIOSTATIONS_PLAYER_REAL_PLAYER', 
	'RADIOSTATIONS_PLAYER_QUICKTIME', 
	'RADIOSTATIONS_DESCRIPTION_ITEM', 
	'RADIOSTATIONS_WEBSITE_ITEM', 
	'RADIOSTATIONS_STATION_OPTIONS', 
	'RADIOSTATIONS_EDITSTATION_FORM', 
	'RADIOSTATIONS_LETTER_MENU', 
	'RADIOSTATIONS_LIST_TABLE', 
	'RADIOSTATIONS_STATION_ENTRY', 
	'RADIOSTATIONS_STATION_LIST', 
	'RADIOSTATIONS_PAGES', 
	'RADIOSTATIONS_FAVORITES_TABLE', 
	'RADIOSTATIONS_FAVORITES_ENTRY', 
	'RADIOSTATIONS_FAVORITES_LIST', 
	'RADIOSTATIONS_STATISTICS_TABLE', 
	'RADIOSTATIONS_STATISTICS_FIELDSET', 
	'RADIOSTATIONS_STATISTICS_ENTRY', 
	'RADIOSTATIONS_REPORTS_TABLE', 
	'RADIOSTATIONS_REPORTS_ENTRY', 
	'RADIOSTATIONS_PLAYER_WINDOW', 
	'RADIOSTATIONS_RATINGS_WINDOW', 
	'RADIOSTATIONS_RATINGS_ENTRY', 
	'RADIOSTATIONS_JAVASCRIPT', 
);

// ######################### REQUIRE BACK-END ############################
require_once('./global.php');
require_once('./includes/class_bbcode.php');

// ############################ CONFIG VARS ##############################
$banned_users = rs_do_array($vbulletin->options['radiostations_banned_users']);
$default_station = $vbulletin->options['radiostations_default_station'];
$stats_results = $vbulletin->options['radiostations_statistics_entries']; // how many top stats entries
$per_page = $vbulletin->options['rs_per_page']; // number of stations per page
$default_player_size = explode('x', $vbulletin->options['radiostations_default_player_size']);
$player_sizes = explode("\r\n", $vbulletin->options['radiostations_player_sizes']);
$default_rp_size = explode('x', $vbulletin->options['radiostations_default_rp_size']);
$rp_sizes = explode("\r\n", $vbulletin->options['radiostations_rp_sizes']);
$default_quick_size = explode('x', $vbulletin->options['radiostations_default_qt_size']);
$quick_sizes = explode("\r\n", $vbulletin->options['radiostations_qt_sizes']);

// ############################# SYSTEM VARS ###############################
$letter_queries = array(
'0-9' => "LOWER(r.name) REGEXP '^[^a-z].*'",
'a' => "LOWER(r.name) LIKE 'a%'",
'b' => "LOWER(r.name) LIKE 'b%'",
'c' => "LOWER(r.name) LIKE 'c%'",
'd' => "LOWER(r.name) LIKE 'd%'",
'e' => "LOWER(r.name) LIKE 'e%'",
'f' => "LOWER(r.name) LIKE 'f%'",
'g' => "LOWER(r.name) LIKE 'g%'",
'h' => "LOWER(r.name) LIKE 'h%'",
'i' => "LOWER(r.name) LIKE 'i%'",
'j' => "LOWER(r.name) LIKE 'j%'",
'k' => "LOWER(r.name) LIKE 'k%'",
'l' => "LOWER(r.name) LIKE 'l%'",
'm' => "LOWER(r.name) LIKE 'm%'",
'n' => "LOWER(r.name) LIKE 'n%'",
'o' => "LOWER(r.name) LIKE 'o%'",
'p' => "LOWER(r.name) LIKE 'p%'",
'q' => "LOWER(r.name) LIKE 'q%'",
'r' => "LOWER(r.name) LIKE 'r%'",
's' => "LOWER(r.name) LIKE 's%'",
't' => "LOWER(r.name) LIKE 't%'",
'u' => "LOWER(r.name) LIKE 'u%'",
'v' => "LOWER(r.name) LIKE 'v%'",
'w' => "LOWER(r.name) LIKE 'w%'",
'x' => "LOWER(r.name) LIKE 'x%'",
'y' => "LOWER(r.name) LIKE 'y%'",
'z' => "LOWER(r.name) LIKE 'z%'",
);

// #######################################################################
// ######################### INITIALIZATION ##############################
// #######################################################################

// use $vbulletin->GPC['name']
$vbulletin->input->clean_array_gpc('r', array(
	'station'         => TYPE_UINT,
	'reportid'        => TYPE_UINT,
	'page'            => TYPE_UINT,
	'name'            => TYPE_STR,
	'description'     => TYPE_STR,
	'url'             => TYPE_STR,
	'website'         => TYPE_STR,
	'letter'          => TYPE_STR,
	'search'          => TYPE_STR,
	'reporttype'      => TYPE_STR,
	'do'              => TYPE_STR,
	'size'            => TYPE_STR,
	'category'        => TYPE_INT,
	'tocat'           => TYPE_INT,
	'fromcat'         => TYPE_INT,
	'rating'          => TYPE_INT,
	'playerid'        => TYPE_INT,
	'deletestations'  => TYPE_BOOL,
));


// players
$players = array(
	0 => $vbphrase['rs_default'],
	1 => $vbphrase['rs_real_player'],
	2 => $vbphrase['rs_quicktime'],
);


// convert urlencoded unicode
$vbulletin->GPC['name'] = convert_urlencoded_unicode($vbulletin->GPC['name']);
$vbulletin->GPC['description'] = convert_urlencoded_unicode($vbulletin->GPC['description']);
$vbulletin->GPC['search'] = convert_urlencoded_unicode($vbulletin->GPC['search']);


// permissions initialization
$rspermissions = array();
$rspermissions['view'] = $permissions['radiotvpermissions'] & $vbulletin->bf_ugp['radiotvpermissions']['canview'];
$rspermissions['add'] = $permissions['radiotvpermissions'] & $vbulletin->bf_ugp['radiotvpermissions']['canadd'];
$rspermissions['delete'] = $permissions['radiotvpermissions'] & $vbulletin->bf_ugp['radiotvpermissions']['candelete'];
$rspermissions['edit'] = $permissions['radiotvpermissions'] & $vbulletin->bf_ugp['radiotvpermissions']['canedit'];
$rspermissions['delete_own'] = $permissions['radiotvpermissions'] & $vbulletin->bf_ugp['radiotvpermissions']['candeleteown'];
$rspermissions['edit_own'] = $permissions['radiotvpermissions'] & $vbulletin->bf_ugp['radiotvpermissions']['caneditown'];
$rspermissions['rate'] = $permissions['radiotvpermissions'] & $vbulletin->bf_ugp['radiotvpermissions']['canrate'];
$rspermissions['favorites'] = $permissions['radiotvpermissions'] & $vbulletin->bf_ugp['radiotvpermissions']['canfavorites'];
$rspermissions['report'] = $permissions['radiotvpermissions'] & $vbulletin->bf_ugp['radiotvpermissions']['canreport'];
$rspermissions['view_reports'] = $permissions['radiotvpermissions'] & $vbulletin->bf_ugp['radiotvpermissions']['canviewreports'];
$rspermissions['edit_categories'] = $permissions['radiotvpermissions'] & $vbulletin->bf_ugp['radiotvpermissions']['caneditcategories'];

// set banned permissions
$is_banned_user = in_array($vbulletin->userinfo['userid'], $banned_users);
if ($is_banned_user) {
	#$rspermissions['view'] = false;
	$rspermissions['add'] = false;
	$rspermissions['delete'] = false;
	$rspermissions['edit'] = false;
	$rspermissions['delete_own'] = false;
	$rspermissions['edit_own'] = false;
	$rspermissions['rate'] = false;
	$rspermissions['favorites'] = false;
	$rspermissions['report'] = false;
	$rspermissions['view_reports'] = false;
	$rspermissions['edit_categories'] = false;
}

// get total stations
$results = $db->query_first("SELECT COUNT(*) as total FROM " . TABLE_PREFIX . "radiostation");
$total_stations = $results['total'];

// get user options
$options = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "radiostation_options
								WHERE userid = " . $vbulletin->userinfo['userid']);


// decide what station to play
$play_station = false;
if (!empty($vbulletin->GPC['station'])) {
	$play_station = $vbulletin->GPC['station'];
} else if (!empty($options['defaultstationid'])) {
	$play_station = $options['defaultstationid'];
} else if (!empty($default_station)) {
	$play_station = $default_station;
} else if (!empty($total_stations)) {
	$play_station = rs_get_random_station();
}


// cache categories
$categories = array();
rs_cache_categories();


// if user isn't allowed to view, spit no permission page
if (empty($rspermissions['view'])) {
	print_no_permission();
	exit;
}



// #######################################################################
// ############################## AJAX ###################################
// #######################################################################

// add station ajax
if ($_REQUEST['ajax'] == 'addstation' AND $rspermissions['add']) {
	// check for info entered correctly
	if (empty($vbulletin->GPC['playerid']) AND $vbulletin->GPC['playerid'] != 0) {
		echo 'error: no player selected';
		exit;
	}
	$alert = '';
	if (empty($vbulletin->GPC['name'])) {
		$alert .= $vbphrase['rs_please_enter_a_name'];
	}
	if (empty($vbulletin->GPC['url'])) {
		$alert .= $vbphrase['rs_please_enter_a_url'];
	}
	if (rs_check_existing_url($vbulletin->GPC['url'])) {
		$alert .= $vbphrase['rs_station_exists'];
	}
	if (!empty($alert)) {
		echo "var doalert = '$alert';";
		exit;
	}
	
	// add station to database
	$db->query_write("INSERT INTO " . TABLE_PREFIX . "radiostation
				(name, url, addedby, dateadded, description, categoryid, website, playerid) 
			VALUES ('" . $db->escape_string($vbulletin->GPC['name']) . "',
					'" . $db->escape_string($vbulletin->GPC['url']) . "',
					" . $vbulletin->userinfo['userid'] . ",
					" . TIMENOW . ",
					'" . $db->escape_string($vbulletin->GPC['description']) . "',
					" . $vbulletin->GPC['category'] . ",
					'" . $db->escape_string($vbulletin->GPC['website']) . "',
					" . $vbulletin->GPC['playerid'] . ")");
	
	// build reply - "station added correctly etc"
	$station = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "radiostation
									WHERE url = '" . $db->escape_string($vbulletin->GPC['url']) . "'
									ORDER BY stationid DESC");
	$reply = rs_construct_station_link($station);
	
	$reply = construct_phrase($vbphrase['rs_station_added'], $reply);
	
	$reply = rs_clean_ajax_reply($reply);
	
	$reply = "var newcontent = '$reply'; var doalert = '';";
	
	echo $reply;
	
	exit;
}


// reset add station ajax
if ($_REQUEST['ajax'] == 'resetaddstationform' AND $rspermissions['add']) {
	$reply = rs_construct_add_station_table();
	$reply = rs_clean_ajax_reply($reply);
	$reply = "var newcontent = '$reply';";
	echo $reply;
	exit;
}


// change station ajax
if ($_REQUEST['ajax'] == 'changestation' AND !empty($vbulletin->GPC['station'])) {
	rs_count_played_station($vbulletin->GPC['station']);
	$reply = rs_construct_station_table($vbulletin->GPC['station']);
	$reply = rs_clean_ajax_reply($reply);
	$reply = "var newcontent = '$reply';";
	echo $reply;
	exit;
}


// random station ajax
if ($_REQUEST['ajax'] == 'randomstation') {
	if (!empty($total_stations)) {
		$play_station = rs_get_random_station();
		rs_count_played_station($play_station);
		$reply = rs_construct_station_table($play_station);
		$reply = rs_clean_ajax_reply($reply);
	} else {
		$reply = '';
	}
	$reply = "var newcontent = '$reply';";
	echo $reply;
	exit;
}


// add category ajax
if ($_REQUEST['ajax'] == 'addcategory' AND $rspermissions['edit_categories']) {
	// check for info entered correctly
	$alert = '';
	if (empty($vbulletin->GPC['name'])) {
		$alert .= $vbphrase['rs_please_enter_a_name'];
	}
	if (!empty($alert)) {
		echo "var doalert = '$alert';";
		exit;
	}
	
	$db->query_write("INSERT INTO " . TABLE_PREFIX . "radiostation_category
				(cat_name) 
			VALUES ('" . $db->escape_string($vbulletin->GPC['name']) . "')");
	
	$reply = construct_phrase($vbphrase['rs_category_x_added'], htmlentities($vbulletin->GPC['name']));
	$reply = rs_clean_ajax_reply($reply);
	$reply = "var newinfo = '$reply';";
	
	rs_cache_categories();
	$category_select = rs_construct_category_select();
	$category_select = rs_clean_ajax_reply($category_select);
	
	$reply = "$reply categorySelect = '$category_select'; var doalert = '';";
	
	echo $reply;
	exit;
}


// edit category ajax
if ($_REQUEST['ajax'] == 'editcategory' AND $rspermissions['edit_categories']) {
	if (empty($vbulletin->GPC['category'])) {
		echo 'noid';
		exit;
	}
	
	// check for info entered correctly
	$alert = '';
	if (empty($vbulletin->GPC['name'])) {
		$alert .= $vbphrase['rs_please_enter_a_name'];
	}
	if (!empty($alert)) {
		echo "var doalert = '$alert';";
		exit;
	}
	
	$db->query_write("UPDATE " . TABLE_PREFIX . "radiostation_category
						SET cat_name = '" . $db->escape_string($vbulletin->GPC['name']) . "'
						WHERE categoryid = " . $vbulletin->GPC['category']);
	
	$reply = construct_phrase($vbphrase['rs_category_x_edited'], htmlentities($vbulletin->GPC['name']));
	$reply = rs_clean_ajax_reply($reply);
	$reply = "var newinfo = '$reply';";
	
	rs_cache_categories();
	$category_select = rs_construct_category_select();
	$category_select = rs_clean_ajax_reply($category_select);
	
	$reply = "$reply categorySelect = '$category_select'; var doalert = '';";
	
	echo $reply;
	exit;
}


// delete category ajax
if ($_REQUEST['ajax'] == 'deletecategory' AND $rspermissions['edit_categories']) {
	if (empty($vbulletin->GPC['category'])) {
		echo 'noid';
		exit;
	}
	
	$name = rs_get_category_name($vbulletin->GPC['category']);
	
	// check for existing stations inside category
	if (empty($vbulletin->GPC['deletestations'])) {
		
		$results = $db->query_first("SELECT COUNT(*) as total FROM " . TABLE_PREFIX . "radiostation
										WHERE categoryid = " . $vbulletin->GPC['category']);
		
		if ($results['total'] > 0) {
			$r = construct_phrase($vbphrase['rs_cat_has_stations'], $name, $results['total']);
			echo "var doalert = '$r';";
			exit;
		}
	}
	
	// delete all stations inside this category
	if (!empty($vbulletin->GPC['deletestations'])) {
		$db->query_write("DELETE FROM " . TABLE_PREFIX . "radiostation
							WHERE categoryid = " . $vbulletin->GPC['category']);
	}
	
	// delete category
	$db->query_write("DELETE FROM " . TABLE_PREFIX . "radiostation_category
						WHERE categoryid = " . $vbulletin->GPC['category']);
	
	$reply = construct_phrase($vbphrase['rs_category_x_deleted'], $name);
	$reply = rs_clean_ajax_reply($reply);
	$reply = "var newinfo = '$reply';";
	
	rs_cache_categories();
	$category_select = rs_construct_category_select();
	$category_select = rs_clean_ajax_reply($category_select);
	
	$reply = "$reply categorySelect = '$category_select'; var doalert = '';";
	
	echo $reply;
	exit;
}


// move stations ajax
if ($_REQUEST['ajax'] == 'movestations' AND $rspermissions['edit_categories']) {
	if (empty($vbulletin->GPC['fromcat']) OR empty($vbulletin->GPC['tocat'])) {
		echo 'noid';
		exit;
	}
	
	$fromname = rs_get_category_name($vbulletin->GPC['fromcat']);
	$toname = rs_get_category_name($vbulletin->GPC['tocat']);
	
	$db->query_write("UPDATE " . TABLE_PREFIX . "radiostation
						SET categoryid = " . $vbulletin->GPC['tocat'] . "
						WHERE categoryid = " . $vbulletin->GPC['fromcat']);
	
	$reply = construct_phrase($vbphrase['rs_moved_x_to_x'], $fromname, $toname);
	$reply = rs_clean_ajax_reply($reply);
	$reply = "var newinfo = '$reply'; var doalert = '';";
	
	echo $reply;
	exit;
}


// rate station ajax
if ($_REQUEST['ajax'] == 'ratestation' AND $rspermissions['rate']) {
	
	$hasrating = rs_get_user_rating($vbulletin->GPC['station']);
	
	if (!empty($hasrating)) {
		$db->query_write("DELETE FROM " . TABLE_PREFIX . "radiostation_rating
							WHERE stationid = " . $vbulletin->GPC['station'] . "
							AND userid = " . $vbulletin->userinfo['userid']);
	}
	
	if ($vbulletin->GPC['rating'] != 0) {
		$db->query_write("INSERT INTO " . TABLE_PREFIX . "radiostation_rating
					(userid, rating, stationid) 
				VALUES (" . $vbulletin->userinfo['userid'] . ",
						" . $vbulletin->GPC['rating'] . ",
						" . $vbulletin->GPC['station'] . ")");
	}
	
	$myrating = rs_get_user_rating($vbulletin->GPC['station']);
	$myrating = rs_clean_ajax_reply($myrating);
	
	$stationrating = rs_get_rating($vbulletin->GPC['station']);
	$stationrating = rs_clean_ajax_reply($stationrating);
	
	$reply = "var myNewRating = '$myrating'; var newStationRating = '$stationrating';";
	
	echo $reply;
	exit;
}


// edit station ajax
if ($_REQUEST['ajax'] == 'editstation' AND !empty($vbulletin->GPC['station'])) {
	if (!$rspermissions['edit']) {
		if (!($rspermissions['edit_own'] AND rs_check_ownership($vbulletin->GPC['station']))) {
			echo 'cant';
			exit;
		}
	}
	
	$reply = rs_construct_station_edit_form($vbulletin->GPC['station']);
	$reply = rs_clean_ajax_reply($reply);
	$reply = "var newcontent = '$reply'; var doalert = ''; var updateall = false;";
	echo $reply;
	exit;
}


// update station ajax
if ($_REQUEST['ajax'] == 'updatestation' AND !empty($vbulletin->GPC['station'])) {
	if (!$rspermissions['edit']) {
		if (!($rspermissions['edit_own'] AND rs_check_ownership($vbulletin->GPC['station']))) {
			echo 'cant';
			exit;
		}
	}
	
	// check for info entered correctly
	if (empty($vbulletin->GPC['playerid']) AND $vbulletin->GPC['playerid'] != 0) {
		echo 'error: no player selected';
		exit;
	}
	$alert = '';
	if (empty($vbulletin->GPC['name'])) {
		$alert .= $vbphrase['rs_please_enter_a_name'];
	}
	if (empty($vbulletin->GPC['url'])) {
		$alert .= $vbphrase['rs_please_enter_a_url'];
	}
	if (rs_check_existing_url($vbulletin->GPC['url'], $vbulletin->GPC['station'])) {
		$alert .= $vbphrase['rs_station_exists'];
	}
	if (!empty($alert)) {
		echo "var doalert = '$alert';";
		exit;
	}
	
	// see if url and playerid changed; update player if it did
	$results = $db->query_first("SELECT url, playerid FROM " . TABLE_PREFIX . "radiostation
									WHERE stationid = " . $vbulletin->GPC['station']);
	$updateall = 0;
	if ($vbulletin->GPC['url'] != $results['url']) {
		$updateall = 1;
	}
	if ($vbulletin->GPC['playerid'] != $results['playerid']) {
		$updateall = 1;
	}
	
	
	
	// update station info
	$db->query_write("UPDATE " . TABLE_PREFIX . "radiostation
					SET
				name        = '" . $db->escape_string($vbulletin->GPC['name']) . "',
				url         = '" . $db->escape_string($vbulletin->GPC['url']) . "',
				description = '" . $db->escape_string($vbulletin->GPC['description']) . "',
				categoryid  = " . $vbulletin->GPC['category'] . ",
				website     = '" . $db->escape_string($vbulletin->GPC['website']) . "',
				playerid    = " . $vbulletin->GPC['playerid'] . "
				WHERE stationid = " . $vbulletin->GPC['station']);
	
	// build reply
	if ($updateall) {
		$reply = rs_construct_station_table($vbulletin->GPC['station']);
	} else {
		$station = rs_get_station($vbulletin->GPC['station']);
		$html_station_info = rs_construct_station_info($station);
		$html_station_options = rs_construct_station_options($station);
		$reply = $html_station_info . $html_station_options;
	}
	
	$reply = rs_clean_ajax_reply($reply);
	
	$reply = "var newcontent = '$reply'; var doalert = ''; var updateall = $updateall;";
	
	echo $reply;
	
	exit;
}


// delete station ajax
if ($_REQUEST['ajax'] == 'deletestation' AND !empty($vbulletin->GPC['station'])) {
	if (!$rspermissions['delete']) {
		if (!($rspermissions['delete_own'] AND rs_check_ownership($vbulletin->GPC['station']))) {
			echo 'cant';
			exit;
		}
	}
	
	$db->query_write("DELETE FROM " . TABLE_PREFIX . "radiostation
						WHERE stationid = " . $vbulletin->GPC['station']);
	
	// remove all reports if station was deleted
	$db->query_write("DELETE FROM " . TABLE_PREFIX . "radiostation_report
						WHERE stationid = " . $vbulletin->GPC['station']);
	
	if (!empty($total_stations)) {
		$play_station = rs_get_random_station();
		rs_count_played_station($play_station);
		$reply = rs_construct_station_table($play_station);
	} else {
		$reply = '';
	}
	$reply = rs_clean_ajax_reply($reply);
	$reply = "var newcontent = '$reply';";
	echo $reply;
	exit;
}


// update list of stations ajax
if ($_REQUEST['ajax'] == 'updatelist') {
	$reply = rs_construct_full_station_list();
	$reply = rs_clean_ajax_reply($reply);
	$reply = "var newcontent = '$reply';";
	echo $reply;
	exit;
}


// favorites ajax
if (($_REQUEST['ajax'] == 'addfavorite' OR $_REQUEST['ajax'] == 'removefavorite' OR $_REQUEST['ajax'] == 'updatefavorites') AND $rspermissions['favorites']) {
	if ($_REQUEST['ajax'] == 'addfavorite' OR $_REQUEST['ajax'] == 'removefavorite') {
		if (empty($vbulletin->GPC['station'])) {
			echo 'noid';
			exit;
		} else {
			$stationid_link = ' var stationid = ' . $vbulletin->GPC['station'] . ';';
		}
	} else {
		$stationid_link = ' var stationid = 0;';
	}
	
	$favorite_link = 0;
	if ($_REQUEST['ajax'] == 'addfavorite') {
		if (!rs_favorite_exists($vbulletin->GPC['station'])) {
			$db->query_write("INSERT INTO " . TABLE_PREFIX . "radiostation_favorite
						(userid, stationid) 
					VALUES (" . $vbulletin->userinfo['userid'] . ",
							" . $vbulletin->GPC['station'] . ")");
			$favorite_link = construct_phrase($vbphrase['rs_remove_favorite'], $vbulletin->GPC['station']);
			$favorite_link = rs_clean_ajax_reply($favorite_link);
			$favorite_link = "'$favorite_link'";
		}
	}
	if ($_REQUEST['ajax'] == 'removefavorite') {
		$db->query_write("DELETE FROM " . TABLE_PREFIX . "radiostation_favorite
							WHERE stationid = " . $vbulletin->GPC['station'] . "
							AND userid = " . $vbulletin->userinfo['userid']);
		$favorite_link = construct_phrase($vbphrase['rs_add_favorite'], $vbulletin->GPC['station']);
		$favorite_link = rs_clean_ajax_reply($favorite_link);
		$favorite_link = "'$favorite_link'";
	}
	
	$favorites_table = rs_construct_favorites_table();
	$favorites_table = rs_clean_ajax_reply($favorites_table);
	
	$reply = "var newcontent = '$favorites_table'; var favorite_link = $favorite_link;";
	$reply .= $stationid_link;
	echo $reply;
	exit;
}


// update statistics ajax
if ($_REQUEST['ajax'] == 'updatestatistics') {
	$reply = rs_construct_statistics_table();
	$reply = rs_clean_ajax_reply($reply);
	$reply = "var newcontent = '$reply';";
	echo $reply;
	exit;
}


// reports ajax
if (($_REQUEST['ajax'] == 'reportstation' AND $rspermissions['report']) OR ($_REQUEST['ajax'] == 'removereport' AND $rspermissions['view_reports']) OR ($_REQUEST['ajax'] == 'updatereports' AND $rspermissions['view_reports'])) {
	if ($_REQUEST['ajax'] == 'reportstation' AND empty($vbulletin->GPC['station'])) {
		echo 'noid';
		exit;
	}
	if ($_REQUEST['ajax'] == 'removereport' AND empty($vbulletin->GPC['reportid'])) {
		echo 'noid';
		exit;
	}
	
	if ($_REQUEST['ajax'] == 'removereport') {
		$db->query_write("DELETE FROM " . TABLE_PREFIX . "radiostation_report
							WHERE reportid = " . $vbulletin->GPC['reportid']);
		$reply = rs_construct_reports_table();
		$reply = rs_clean_ajax_reply($reply);
	}
	
	if ($_REQUEST['ajax'] == 'reportstation' AND rs_report_exists($vbulletin->GPC['station'])) {
		$reply = $vbphrase['rs_already_reported'];
		$reply = rs_clean_ajax_reply($reply);
	} else if ($_REQUEST['ajax'] == 'reportstation') {
		$report_type = 1;
		if ($vbulletin->GPC['reporttype'] == 'duplicate') {
			$report_type = 2;
		}
		$db->query_write("INSERT INTO " . TABLE_PREFIX . "radiostation_report
					(userid, stationid, type) 
				VALUES (" . $vbulletin->userinfo['userid'] . ",
						" . $vbulletin->GPC['station'] . ",
						" . $report_type . ")");
		$reply = $vbphrase['rs_thank_you_for_report'];
		$reply = rs_clean_ajax_reply($reply);
	}
	
	if ($_REQUEST['ajax'] == 'updatereports') {
		$reply = rs_construct_reports_table();
		$reply = rs_clean_ajax_reply($reply);
	}
	
	$reply = "var newcontent = '$reply';";
	echo $reply;
	exit;
}





// #######################################################################
// ############################# POP-UPS #################################
// #######################################################################

if ($vbulletin->GPC['do'] == 'playerwindow' AND !empty($vbulletin->GPC['station'])) {
	
	$station = rs_get_station($vbulletin->GPC['station']);
	
	if ($station['playerid'] == 1) {
		$player = 'rp';
		$default_sizes = $rp_sizes;
	} else if ($station['playerid'] == 2) {
		$player = 'qt';
		$default_sizes = $quick_sizes;
	} else {
		$player = 'wmp';
		$default_sizes = $player_sizes;
	}
	
	// get first size of the default sizes
	$default_size = $default_sizes[0];
	
	// decide player size
	if (!empty($vbulletin->GPC['size'])) {
		$size = explode('x', $vbulletin->GPC['size']);
		if (!is_numeric($size[0]) OR !is_numeric($size[1])) {
			$size = explode('x', $default_size);
		}
	} else {
		$size = explode('x', $default_size);
	}
	if (!is_numeric($size[0]) OR !is_numeric($size[1])) {
		$size = explode('x', '640x480');
	}
	
	$html_width  = $size[0];
	$html_height = $size[1];
	$html_url    = htmlentities($station['url']);
	$html_sizes  = rs_construct_player_sizes_links($default_sizes, $vbulletin->GPC['station']);
	
	if ($station['playerid'] == 1) { //it's Real Player
		eval('$html_player = "' . fetch_template('RADIOSTATIONS_PLAYER_REAL_PLAYER') . '";');
	} else if ($station['playerid'] == 2) { //it's quicktime
		eval('$html_player = "' . fetch_template('RADIOSTATIONS_PLAYER_QUICKTIME') . '";');
	} else {
		eval('$html_player = "' . fetch_template('RADIOSTATIONS_PLAYER') . '";');
	}
	
	eval('print_output("' . fetch_template('RADIOSTATIONS_PLAYER_WINDOW') . '");');
	exit;
}

if ($vbulletin->GPC['do'] == 'ratingswindow' AND !empty($vbulletin->GPC['station'])) {
	
	$ratings = rs_get_station_ratings($vbulletin->GPC['station']);
	
	$html_entries = '';
	
	foreach ($ratings AS $rating) {
		$name = fetch_musername($rating);
		$html_user = "<a href=\"member.php?u=$report[userid]\" target=\"blank\">$name</a>";
		$html_rating = "<img class=\"inlineimg\" src=\"$stylevar[imgdir_rating]/rating_$rating[rating].gif\" border=\"0\" /> ";
		$html_station_name = htmlentities($rating['name']);
		eval('$html_entries .= "' . fetch_template('RADIOSTATIONS_RATINGS_ENTRY') . '";');
	}
	
	if (empty($html_entries)) {
		$html_entries = $vbphrase['rs_no_ratings'];
	}
	
	eval('print_output("' . fetch_template('RADIOSTATIONS_RATINGS_WINDOW') . '");');
	exit;
}


// #######################################################################
// ############################ MAIN PAGE ################################
// #######################################################################

// currently playing
$html_station = '';

if ($play_station) {
	rs_count_played_station($play_station);
	$html_station = rs_construct_station_table($play_station);
}

$html_station = '<div id="stationTableDiv">' . $html_station . '</div>';


// favorites
if ($rspermissions['favorites']) {
	$html_favorites_table = rs_construct_favorites_table();
	$html_favorites_table = '<div id="favoritesTableDiv">' . $html_favorites_table . '</div>';
}


// add station table
if ($rspermissions['add']) {
	$html_add_station = rs_construct_add_station_table();
	$html_add_station = '<div id="addStationTableDiv">' . $html_add_station . '</div>';
}


// stations list

//// navbar
$html_category_list = rs_construct_category_select(true);
$html_random_station = rs_construct_random_station_link();
eval('$html_station_list_navbar = "' . fetch_template('RADIOSTATIONS_STATIONS_NAVBAR') . '";');

$html_station_list = rs_construct_full_station_list();

eval('$html_stations_table = "' . fetch_template('RADIOSTATIONS_STATIONS_TABLE') . '";');


// manage categories
$html_manage_categories = '';

if ($rspermissions['edit_categories']) {
	$html_category_list = rs_construct_category_select();
	$html_fromcategory_list = rs_construct_category_select(false, 'fromcat');
	$html_tocategory_list = rs_construct_category_select(false, 'tocat');
	eval('$html_manage_categories = "' . fetch_template('RADIOSTATIONS_EDITCAT_TABLE') . '";');
}


// statistics
$html_statistics_table = rs_construct_statistics_table();
$html_statistics_table = '<div id="statisticsTableDiv">' . $html_statistics_table . '</div>';


// reports
if ($rspermissions['view_reports']) {
	$html_reports_table = rs_construct_reports_table();
	$html_reports_table = '<div id="reportsTableDiv">' . $html_reports_table . '</div>';
}



# wooooooooooooooooon't someone listen
# nobody gets in
# my booooooody's a temple
# but nooooooooooothing is simple

// spit page
eval('$html_javascript = "' . fetch_template('RADIOSTATIONS_JAVASCRIPT') . '";');
eval('print_output("' . fetch_template('RADIOSTATIONS') . '");');

// #######################################################################
// ############################ FUNCTIONS ################################
// #######################################################################

function rs_do_array($string) {
	$return = array();
	$junks = explode(',', $string);
	foreach ($junks AS $junk) {
		$return[] = trim($junk);
	}
	return $return;
}

function rs_has_intersection($array1, $array2) {
	foreach ($array1 AS $value1) {
		if (in_array($value1, $array2)) {
			return true;
		}
	}
	return false;
}

function rs_cache_categories() {
	global $categories, $db;
	$categories = array();
	$results = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "radiostation_category
								ORDER BY cat_name ASC");
	while( $cat = $db->fetch_array( $results ) ) {
		$categories[] = array('id' => $cat['categoryid'], 'name' => htmlentities($cat['cat_name']));
	}
}

function rs_clean_ajax_reply($reply) {
	$reply = str_replace('\\', '\\\\', $reply);
	$reply = str_replace("'", "\\'", $reply);
	$reply = str_replace("\r\n", "", $reply);
	$reply = str_replace("\n", "", $reply);
	return $reply;
}

function rs_count_played_station($stationid) {
	global $db;
	$db->query_write("UPDATE " . TABLE_PREFIX . "radiostation SET played = played + 1
						WHERE stationid = $stationid");
}

function rs_check_ownership($stationid) {
	global $vbulletin, $db;
	$results = $db->query_first("SELECT addedby FROM " . TABLE_PREFIX . "radiostation
									WHERE stationid = " . $stationid);
	if ($vbulletin->userinfo['userid'] == $results['addedby']) {
		return true;
	}
	return false;
}

function rs_check_existing_url($url, $stationid = false) {
	global $db;
	$exclude = '';
	if (!empty($stationid)) {
		$exclude = " AND stationid != $stationid";
	}
	$results = $db->query_first("SELECT url FROM " . TABLE_PREFIX . "radiostation
									WHERE url = '" . $db->escape_string($url) . "' $exclude");
	if (!empty($results['url'])) {
		return true;
	}
	return false;
}

function rs_favorite_exists($stationid) {
	global $db, $vbulletin;
	$results = $db->query_first("SELECT favoriteid FROM " . TABLE_PREFIX . "radiostation_favorite
									WHERE userid = " . $vbulletin->userinfo['userid'] . "
									AND stationid = " . $stationid);
	if (!empty($results['favoriteid'])) {
		return true;
	}
	return false;
}

function rs_report_exists($stationid) {
	global $db, $vbulletin;
	$results = $db->query_first("SELECT reportid FROM " . TABLE_PREFIX . "radiostation_report
									WHERE userid = " . $vbulletin->userinfo['userid'] . "
									AND stationid = " . $stationid);
	if (!empty($results['reportid'])) {
		return true;
	}
	return false;
}

function rs_last_played_exists($userid) {
	global $db, $vbulletin;
	$results = $db->query_first("SELECT dateplayed FROM " . TABLE_PREFIX . "radiostation_lastplayed
									WHERE userid = " . $userid);
	if (!empty($results['dateplayed'])) {
		return true;
	}
	return false;
}

function rs_update_last_played($userid, $stationid) {
	global $db, $vbulletin;
	$exists = rs_last_played_exists($userid);
	if ($exists) {
		$db->query_write("UPDATE " . TABLE_PREFIX . "radiostation_lastplayed
							SET stationid = " . $stationid . ", dateplayed = " . TIMENOW . "
							WHERE userid = " . $userid);
	} else {
		$db->query_write("INSERT INTO " . TABLE_PREFIX . "radiostation_lastplayed
					(userid, stationid, dateplayed) 
				VALUES (" . $userid . ",
						" . $stationid . ",
						" . TIMENOW . ")");
	}
}

function rs_make_query_conditions() {
	global $vbulletin, $letter_queries, $db;
	$conditions = array();
	if (!empty($vbulletin->GPC['letter'])) {
		if (empty($letter_queries[$vbulletin->GPC['letter']])) {
			return '';
		}
		$conditions[] = $letter_queries[$vbulletin->GPC['letter']];
	}
	if (!empty($vbulletin->GPC['category'])) {
		$conditions[] = 'r.categoryid = ' . $vbulletin->GPC['category'];
	}
	if (!empty($vbulletin->GPC['search'])) {
		$conditions[] = "r.name LIKE '%" . $db->escape_string($vbulletin->GPC['search']) . "%'";
	}
	$conditions = implode(' AND ', $conditions);
	if (empty($conditions)) {
		return '';
	}
	return "WHERE $conditions";
}

function rs_calc_query_limit($page) {
	global $per_page;
	$start = ($page - 1) * $per_page;
	return "LIMIT $start, $per_page";
}

function rs_calc_number_of_pages($total) {
	global $per_page;
	return ceil($total / $per_page);
}



function rs_get_total_stations_in_list() {
	global $db;
	$conditions = rs_make_query_conditions();
	$results = $db->query_first("SELECT COUNT(*) as total FROM " . TABLE_PREFIX . "radiostation as r
									$conditions");
	return $results['total'];
}

function rs_get_random_station() {
	global $db, $total_stations;
	$limit = rand(1, $total_stations) - 1;
	$results = $db->query_first("SELECT stationid FROM " . TABLE_PREFIX . "radiostation
									ORDER BY stationid ASC
									LIMIT $limit, 1");
	return $results['stationid'];
}

function rs_get_rating($stationid) {
	global $db, $vbphrase, $stylevar;
	$results = $db->query_first("SELECT COUNT(*) as ratings, SUM(rating) / COUNT(*) AS average, stationid
									FROM " . TABLE_PREFIX . "radiostation_rating
									WHERE stationid = $stationid
									GROUP BY stationid");
	return rs_construct_rating($results);
}

function rs_get_station_ratings($stationid) {
	global $db;
	$list = array();
	$results = $db->query_read("
				SELECT rr.rating, rr.userid, u.username, u.usergroupid, u.displaygroupid, r.name FROM " . TABLE_PREFIX . "radiostation_rating AS rr
				LEFT JOIN " . TABLE_PREFIX . "radiostation AS r ON (r.stationid = rr.stationid)
				LEFT JOIN " . TABLE_PREFIX . "user AS u ON (u.userid = rr.userid)
				WHERE rr.stationid = $stationid");
	while( $entry = $db->fetch_array( $results ) ) {
		$list[] = $entry;
	}
	return $list;
}

function rs_get_user_rating($stationid) {
	global $db, $vbphrase, $vbulletin, $stylevar;
	$results = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "radiostation_rating
									WHERE userid = " . $vbulletin->userinfo['userid'] . "
									AND stationid = " . $stationid);
	if (empty($results['rating'])) {
		return '';
	}
	$stars = "<img class=\"inlineimg\" src=\"$stylevar[imgdir_rating]/rating_$results[rating].gif\" border=\"0\" /> ";
	return construct_phrase($vbphrase['rs_your_vote_x'], $stars);
}

function rs_get_category_name($categoryid) {
	global $db;
	$results = $db->query_first("SELECT cat_name FROM " . TABLE_PREFIX . "radiostation_category
									WHERE categoryid = $categoryid");
	return $results['cat_name'];
}

function rs_get_user_name($userid) {
	global $db;
	return $db->query_first("SELECT userid, username, usergroupid, displaygroupid 
								FROM " . TABLE_PREFIX . "user
								WHERE userid = $userid");
}

function rs_get_top_rated_stations() {
	global $db, $stats_results;
	$stations = array();
	
	$results = $db->query_read("
				SELECT *, r.stationid, COUNT(rt.stationid) as ratings, SUM(rt.rating) / COUNT(rt.stationid) AS average FROM " . TABLE_PREFIX . "radiostation AS r
				LEFT JOIN " . TABLE_PREFIX . "radiostation_rating AS rt ON (r.stationid = rt.stationid)
				GROUP BY r.stationid
				ORDER BY average DESC, ratings DESC LIMIT 0, $stats_results");
	
	while( $station = $db->fetch_array( $results ) ) {
		$stations[] = $station;
	}
	
	return $stations;
}

function rs_get_newest_stations() {
	global $db, $stats_results;
	$stations = array();
	
	$results = $db->query_read("
				SELECT * FROM " . TABLE_PREFIX . "radiostation
				ORDER BY dateadded DESC LIMIT 0, $stats_results");
	
	while( $station = $db->fetch_array( $results ) ) {
		$stations[] = $station;
	}
	
	return $stations;
}

function rs_get_most_played_stations() {
	global $db, $stats_results;
	$stations = array();
	
	$results = $db->query_read("
				SELECT * FROM " . TABLE_PREFIX . "radiostation
				ORDER BY played DESC LIMIT 0, $stats_results");
	
	while( $station = $db->fetch_array( $results ) ) {
		$stations[] = $station;
	}
	
	return $stations;
}

function rs_get_largest_categories() {
	global $db, $stats_results;
	$stations = array();
	
	$results = $db->query_read("
				SELECT *, COUNT(r.stationid) as total FROM " . TABLE_PREFIX . "radiostation_category AS rc
				LEFT JOIN " . TABLE_PREFIX . "radiostation AS r ON (r.categoryid = rc.categoryid)
				GROUP BY rc.categoryid
				ORDER BY total DESC LIMIT 0, $stats_results");
	
	while( $station = $db->fetch_array( $results ) ) {
		$stations[] = $station;
	}
	
	return $stations;
}

function rs_get_stations($page) {
	global $db;
	$stations = array();
	
	$conditions = rs_make_query_conditions();
	$limit = rs_calc_query_limit($page);
	
	$results = $db->query_read("
				SELECT *, r.stationid, COUNT(rt.stationid) as ratings, SUM(rt.rating) / COUNT(rt.stationid) AS average FROM " . TABLE_PREFIX . "radiostation AS r
				LEFT JOIN " . TABLE_PREFIX . "radiostation_category AS c ON (r.categoryid = c.categoryid)
				LEFT JOIN " . TABLE_PREFIX . "radiostation_rating AS rt ON (r.stationid = rt.stationid)
				$conditions
				GROUP BY r.stationid
				ORDER BY name ASC $limit");
	
	while( $station = $db->fetch_array( $results ) ) {
		$stations[] = $station;
	}
	
	return $stations;
}

function rs_get_favorite_stations() {
	global $db, $vbulletin;
	$stations = array();
	
	$results = $db->query_read("
				SELECT *, r.stationid, COUNT(rt.stationid) as ratings, SUM(rt.rating) / COUNT(rt.stationid) AS average FROM " . TABLE_PREFIX . "radiostation_favorite AS rf
				LEFT JOIN " . TABLE_PREFIX . "radiostation AS r ON (r.stationid = rf.stationid)
				LEFT JOIN " . TABLE_PREFIX . "radiostation_rating AS rt ON (r.stationid = rt.stationid)
				LEFT JOIN " . TABLE_PREFIX . "radiostation_category AS c ON (r.categoryid = c.categoryid)
				WHERE rf.userid = " . $vbulletin->userinfo['userid'] . "
				GROUP BY r.stationid
				ORDER BY r.name ASC $limit");
	
	while( $station = $db->fetch_array( $results ) ) {
		$stations[] = $station;
	}
	
	return $stations;
}

function rs_get_reports() {
	global $db;
	
	$results = $db->query_read("
				SELECT rr.reportid, rr.userid, rr.stationid, rr.type, u.userid, u.username, u.usergroupid, u.displaygroupid, r.name FROM " . TABLE_PREFIX . "radiostation_report AS rr
				LEFT JOIN " . TABLE_PREFIX . "radiostation AS r ON (r.stationid = rr.stationid)
				LEFT JOIN " . TABLE_PREFIX . "user AS u ON (u.userid = rr.userid)
				ORDER BY rr.reportid DESC");
	
	$reports = array();
	while( $report = $db->fetch_array( $results ) ) {
		$reports[] = $report;
	}
	return $reports;
}



function rs_construct_player_sizes_links($sizes, $stationid) {
	$r = array();
	foreach ($sizes AS $size) {
		$r[] = '<a href="radioandtv.php?do=playerwindow&station=' . urlencode($stationid) . '&size=' . urlencode($size) . '">' . htmlentities($size) . '</a>';
	}
	$r = implode(' &nbsp; &nbsp; &nbsp; &nbsp; ', $r);
	return $r;
}

function rs_construct_reports_table() {
	global $vbulletin, $vbphrase, $stylevar, $vbcollapse;
	
	$reports = rs_get_reports();
	
	$html_entries = '';
	foreach($reports AS $report) {
		$html_name        = rs_construct_station_link($report);
		$html_type        = $vbphrase['rs_station_doesnt_work'];
		if ($report['type'] == 2) {
			$html_type    = $vbphrase['rs_duplicate_station'];
		}
		$name = fetch_musername($report);
		$html_reported_by = "<a href=\"member.php?u=$report[userid]\" target=\"blank\">$name</a>";
		$html_remove      = construct_phrase($vbphrase['rs_remove_report'], $report['reportid']);
		
		eval('$html_entries .= "' . fetch_template('RADIOSTATIONS_REPORTS_ENTRY') . '";');
	}
	
	if (empty($html_entries)) {
		return '';
	}
	
	eval('$html_reports_table = "' . fetch_template('RADIOSTATIONS_REPORTS_TABLE') . '";');
	
	return $html_reports_table;
}

function rs_construct_statistics_table() {
	global $vbulletin, $vbphrase, $stylevar, $vbcollapse;
	
	$newest_stations      = rs_get_newest_stations();
	$top_rated_stations   = rs_get_top_rated_stations();
	$most_played_stations = rs_get_most_played_stations();
	$largest_categories   = rs_get_largest_categories();
	
	// newest stations
	$html_fieldset_title = $vbphrase['rs_newest_stations'];
	$html_entries = '';
	foreach($newest_stations AS $station) {
		$html_one = rs_construct_station_link($station);
		$html_two = vbdate($vbulletin->options['dateformat'], $station['dateadded']);
		eval('$html_entries .= "' . fetch_template('RADIOSTATIONS_STATISTICS_ENTRY') . '";');
	}
	eval('$html_newest_stations = "' . fetch_template('RADIOSTATIONS_STATISTICS_FIELDSET') . '";');
	
	// top rated stations
	$html_fieldset_title = $vbphrase['rs_top_rated_stations'];
	$html_entries = '';
	foreach($top_rated_stations AS $station) {
		$html_one = rs_construct_station_link($station);
		$html_two = rs_construct_rating($station);
		eval('$html_entries .= "' . fetch_template('RADIOSTATIONS_STATISTICS_ENTRY') . '";');
	}
	eval('$html_top_rated = "' . fetch_template('RADIOSTATIONS_STATISTICS_FIELDSET') . '";');
	
	// most played stations
	$html_fieldset_title = $vbphrase['rs_most_played_stations'];
	$html_entries = '';
	foreach($most_played_stations AS $station) {
		$html_one = rs_construct_station_link($station);
		$html_two = construct_phrase($vbphrase['rs_played_x_times'], $station['played']);
		eval('$html_entries .= "' . fetch_template('RADIOSTATIONS_STATISTICS_ENTRY') . '";');
	}
	eval('$html_most_played = "' . fetch_template('RADIOSTATIONS_STATISTICS_FIELDSET') . '";');
	
	// largest categories
	$html_fieldset_title = $vbphrase['rs_largest_categories'];
	$html_entries = '';
	foreach($largest_categories AS $category) {
		$html_one = htmlentities($category['cat_name']);
		$html_two = construct_phrase($vbphrase['rs_x_stations'], $category['total']);
		eval('$html_entries .= "' . fetch_template('RADIOSTATIONS_STATISTICS_ENTRY') . '";');
	}
	eval('$html_largest_categories = "' . fetch_template('RADIOSTATIONS_STATISTICS_FIELDSET') . '";');
	
	
	eval('$html_statistics_table = "' . fetch_template('RADIOSTATIONS_STATISTICS_TABLE') . '";');
	
	return $html_statistics_table;
}

function rs_construct_favorites_table() {
	global $vbulletin, $vbphrase, $stylevar, $vbcollapse;
	
	$stations = rs_get_favorite_stations();
	
	$html_entries = rs_construct_favorites_entries($stations);
	eval('$html_favorites = "' . fetch_template('RADIOSTATIONS_FAVORITES_LIST') . '";');
	
	eval('$html_favorites_table = "' . fetch_template('RADIOSTATIONS_FAVORITES_TABLE') . '";');
	
	if (empty($html_entries)) {
		return '';
	}
	
	return $html_favorites_table;
}

function rs_construct_favorites_entries($stations) {
	global $vbphrase, $vbulletin;
	
	$html_list = '';
	
	foreach ($stations AS $station) {
		
		$html_name         = rs_construct_station_link($station);
		$html_category     = htmlentities($station['cat_name']);
		$html_played       = construct_phrase($vbphrase['rs_played_x_times'], $station['played']);
		$html_rating       = rs_construct_rating($station);
		$html_remove_link  = '<a href="javascript:removeFavorite(' . $station['stationid'] . ')">' . $vbphrase['rs_remove'] . '</a>';
		
		eval('$html_list .= "' . fetch_template('RADIOSTATIONS_FAVORITES_ENTRY') . '";');
	}
	
	if (empty($html_list)) {
		return '';
	}
	
	return $html_list;
}

function rs_construct_full_station_list() {
	global $vbulletin, $vbphrase, $stylevar;
	
	// make url parameters
	$category_param = '';
	$letter_param = '';
	$search_param = '';
	if (!empty($vbulletin->GPC['category'])) {
		$category_param = '&category=' . urlencode($vbulletin->GPC['category']);
	}
	if (!empty($vbulletin->GPC['letter'])) {
		$letter_param = '&letter=' . urlencode($vbulletin->GPC['letter']);
	}
	if (!empty($vbulletin->GPC['search'])) {
		$search_param = '&search=' . urlencode($vbulletin->GPC['search']);
	}
	
	$total_stations_in_list = rs_get_total_stations_in_list();
	
	// make pagination
	$pages = rs_calc_number_of_pages($total_stations_in_list);
	$page = $vbulletin->GPC['page'];
	if (empty($page)) {
		$page = 1;
	}
	$html_pages = rs_construct_pages_navigation($pages, $category_param . $letter_param . $search_param);
	
	// make breadcrumbs
	if (!empty($vbulletin->GPC['category'])) {
		$category_breadcrumb = construct_phrase($vbphrase['rs_category_x'], rs_get_category_name($vbulletin->GPC['category']));
		$html_breadcrumbs = '<a href="javascript:updateStationList(\'' . $category_param . '\')">' . $category_breadcrumb . '</a>';
	} else {
		$category_breadcrumb = construct_phrase($vbphrase['rs_category_x'], $vbphrase['rs_all_categories_name']);
		$html_breadcrumbs = '<a href="javascript:updateStationList(\'\')">' . $category_breadcrumb . '</a>';
	}
	if (!empty($vbulletin->GPC['search'])) {
		$html_breadcrumbs = '<a href="javascript:updateStationList(\'' . $search_param . '\')">' . construct_phrase($vbphrase['rs_search_x'], htmlentities($vbulletin->GPC['search'])) . '</a>';
	}
	if (!empty($vbulletin->GPC['letter'])) {
		$html_breadcrumbs .= ' &gt; <a href="javascript:updateStationList(\'' . $category_param . $letter_param . '\')">' . construct_phrase($vbphrase['rs_letter_x'], htmlentities($vbulletin->GPC['letter'])) . '</a>';
	}
	if (!empty($vbulletin->GPC['page'])) {
		$html_breadcrumbs .= ' &gt; <a href="javascript:updateStationList(\'' . $category_param . $letter_param . '&page=' . $vbulletin->GPC['page'] . '\')">' . construct_phrase($vbphrase['rs_page_x'], $vbulletin->GPC['page']) . '</a>';
	}
	
	
	// get stations
	$stations = rs_get_stations($page);
	$html_entries = rs_construct_station_entries($stations);
	
	// letter menu
	$html_url_param = $category_param . $search_param;
	eval('$html_letter_menu = "' . fetch_template('RADIOSTATIONS_LETTER_MENU') . '";');
	
	eval('$html_stations = "' . fetch_template('RADIOSTATIONS_LIST_TABLE') . '";');
	eval('$r = "' . fetch_template('RADIOSTATIONS_STATION_LIST') . '";');
	return $r;
}

function rs_construct_pages_navigation($pages, $html_param, $js_function = 'updateStationList') {
	global $vbphrase, $stylevar;
	
	if ($pages < 2) {
		return '';
	}
	
	$html_page_links = '';
	for ($i = 1; $i <= $pages; $i++) {
		$html_page_links .= ' <a href="javascript:' . $js_function . '(\'&page=' . $i . $html_param .'\')">' . $i . '</a>';
	}
	
	eval('$r = "' . fetch_template('RADIOSTATIONS_PAGES') . '";');
	return $r;
}

function rs_construct_station_entries($stations) {
	global $vbphrase, $vbulletin;
	
	$html_list = '';
	
	foreach ($stations AS $station) {
		
		$html_name         = rs_construct_station_link($station);
		$html_catlink      = '&category=' . $station['categoryid'];
		$html_category     = htmlentities($station['cat_name']);
		$html_played       = construct_phrase($vbphrase['rs_played_x_times'], $station['played']);
		$html_rating       = rs_construct_rating($station);
		$html_dateadded    = vbdate($vbulletin->options['dateformat'], $station['dateadded']);
		
		eval('$html_list .= "' . fetch_template('RADIOSTATIONS_STATION_ENTRY') . '";');
	}
	
	if (empty($html_list)) {
		return '<tr><td class="alt1" colspan="4" align="center"><strong>' . $vbphrase['rs_no_stations'] . '</strong></td></tr>';
	}
	
	return $html_list;
}

function rs_construct_rating($results) {
	global $vbphrase, $stylevar;
	if ($results['ratings'] == 0) {
		return $vbphrase['rs_not_rated'];
	}
	$rounded = round($results['average']);
	$average = vb_number_format($results['average'], 2);
	$r = "<img class=\"inlineimg\" src=\"$stylevar[imgdir_rating]/rating_$rounded.gif\" border=\"0\" /> ";
	$r .= construct_phrase($vbphrase['rs_average_x_votes'], $average, $results['stationid'], $results['ratings']);
	return $r;
}

function rs_construct_random_station_link() {
	global $vbphrase;
	return '<a href="javascript:randomStation()">' . $vbphrase['rs_random_station'] . '</a>';
}

function rs_construct_user_link($userid) {
	$user = rs_get_user_name($userid);
	$name = fetch_musername($user);
	return "<a href=\"member.php?u=$user[userid]\" target=\"blank\">$name</a>";
}

function rs_construct_favorite_link($stationid) {
	global $vbphrase;
	if (rs_favorite_exists($stationid)) {
		$r = construct_phrase($vbphrase['rs_remove_favorite'], $stationid);
	} else {
		$r = construct_phrase($vbphrase['rs_add_favorite'], $stationid);
	}
	return $r;
}

function rs_construct_category_select($add_all = false, $name = 'category', $selected = false) {
	global $categories, $vbphrase;
	$select = '';
	
	if ($add_all) {
		$select .= '<option value="">' . $vbphrase['rs_all_categories'] . '</option>';
	}
	
	foreach ($categories AS $cat) {
		$html_select = '';
		if ($selected == $cat['id']) {
			$html_select = ' selected="selected"';
		}
		$select .= "\n" . '<option value="' . $cat['id'] . '"' . $html_select . '>' . htmlentities($cat['name']) . '</option>';
	}
	
	$select = '<select name="' . $name . '">' . $select . '</select>';
	
	return $select;
}

function rs_construct_player_select($selected = false) {
	global $players;
	$select = '';
	
	foreach ($players AS $k => $v) {
		$html_select = '';
		if ($selected == $k) {
			$html_select = ' selected="selected"';
		}
		$select .= "\n" . '<option value="' . $k . '"' . $html_select . '>' . $v . '</option>';
	}
	
	$select = '<select name="playerid">' . $select . '</select>';
	
	return $select;
}

function rs_construct_add_station_table() {
	global $vbphrase, $stylevar, $vbcollapse;
	$html_player_list   = rs_construct_player_select();
	$html_category_list = rs_construct_category_select();
	eval('$html_add_station = "' . fetch_template('RADIOSTATIONS_ADDSTATION_TABLE') . '";');
	return $html_add_station;
}

function rs_construct_url_link($url) {
	global $vbphrase;
	return '<a href="' . $url . '" target="_blank">' . $vbphrase['rs_right_click_to_copy'] . '</a>';
}

function rs_construct_website_link($url) {
	global $vbphrase;
	return '<a href="' . $url . '" target="_blank">' . $vbphrase['rs_click_to_open'] . '</a>';
}

function rs_construct_description_item($desc) {
	global $vbphrase;
	if (empty($desc)) {
		return '';
	}
	$html_description  = $desc;
	eval('$html_description = "' . fetch_template('RADIOSTATIONS_DESCRIPTION_ITEM') . '";');
	return $html_description;
}

function rs_construct_website_item($website) {
	global $vbphrase;
	if (empty($website)) {
		return '';
	}
	$html_website  = rs_construct_website_link($website);
	eval('$html_website = "' . fetch_template('RADIOSTATIONS_WEBSITE_ITEM') . '";');
	return $html_website;
}

function rs_construct_permalink($stationid) {
	return rs_construct_url_link('radioandtv.php?station=' . $stationid);
}

function rs_construct_rate_station($stationid) {
	global $vbulletin, $vbphrase;
	$select  = '<option value="0">' . $vbphrase['rs_none'] . '</option>';
	$select .= '<option value="1">1 - ' . $vbphrase['rs_terrible'] . '</option>';
	$select .= '<option value="2">2 - ' . $vbphrase['rs_bad'] . '</option>';
	$select .= '<option value="3">3 - ' . $vbphrase['rs_average'] . '</option>';
	$select .= '<option value="4">4 - ' . $vbphrase['rs_good'] . '</option>';
	$select .= '<option value="5">5 - ' . $vbphrase['rs_excellent'] . '</option>';
	$select = '<select name="rating" id="ratingSelect">' . $select . '</select>';
	
	$button = '<input type="Button" value="' . $vbphrase['rs_rate'] . '" onclick="javascript:rateStation()" class="button" id="rateButton">';
	
	$div = rs_get_user_rating($stationid);
	$div = '<span id="myRating">' . $div . '</span><br />';
	
	return "$select $button $div";
}

function rs_construct_station_edit_form($stationid) {
	global $vbphrase, $stylevar;
	
	$station = rs_get_station($stationid);
	
	$html_fieldset_title = $vbphrase['rs_currently_playing'];
	
	$html_name          = htmlentities($station['name']);
	$html_url           = htmlentities($station['url']);
	$html_player_list   = rs_construct_player_select($station['playerid']);
	$html_category_list = rs_construct_category_select(false, 'category', $station['categoryid']);
	$html_description   = htmlentities($station['description']);
	$html_website       = htmlentities($station['website']);
	$html_stationid     = $stationid;
	
	eval('$reply = "' . fetch_template('RADIOSTATIONS_EDITSTATION_FORM') . '";');
	
	return $reply;
}

function rs_construct_station_info($station) {
	global $vbulletin, $vbphrase, $stylevar, $rspermissions, $vbcollapse;
	
	// parse description; parse only smilies :)
	$parser =& new vB_BbCodeParser($vbulletin, array());
	$description = $parser->do_parse($station['description'], false, true, false, false, false, false);
	$description = nl2br($description);
	
	$html_station_name = '#' . $station['stationid'] . '  ' . htmlentities($station['name']);
	$html_url          = rs_construct_url_link(urlencode($station['url']));
	$html_website      = rs_construct_website_item(htmlentities($station['website']));
	$html_description  = rs_construct_description_item($description);
	$html_category     = rs_get_category_name($station['categoryid']);
	$html_dateadded    = vbdate($vbulletin->options['dateformat'], $station['dateadded']);
	$html_addedby      = rs_construct_user_link(htmlentities($station['addedby']));
	$html_played       = construct_phrase($vbphrase['rs_played_x_times'], $station['played']);
	$html_rating       = '<div id="stationRating">' . rs_get_rating($station['stationid']) . '</div>';
	$html_stationid    = $station['stationid'];
	$html_permalink    = rs_construct_permalink($station['stationid']);
	
	$html_fieldset_title = $vbphrase['rs_currently_playing'];
	
	eval('$html_station_info = "' . fetch_template('RADIOSTATIONS_STATION_INFO') . '";');
	
	return $html_station_info;
}

function rs_construct_option_item($item) {
# uncomment this for version 1.2 template style
#	return '<tr><td class="smallfont">' . $item . '</td></tr>';
	return '<tr><td class="alt1"><div class="smallfont">' . $item . '</div></td></tr>';
}

function rs_construct_station_options($station) {
	global $vbulletin, $vbphrase, $rspermissions, $stylevar, $vbcollapse;
	
	$html_fieldset_title = $vbphrase['rs_options'];
	
	$hasoptions = false;
	
	if ($rspermissions['rate']) {
		$html_rate_station = rs_construct_rate_station($station['stationid']);
		$html_rate_station = rs_construct_option_item($html_rate_station);
		$hasoptions = true;
	}
	
	if ($rspermissions['edit'] OR 
			($rspermissions['edit_own'] AND $vbulletin->userinfo['userid'] == $station['addedby'])) {
		$html_edit_station = construct_phrase($vbphrase['rs_edit_station'], $station['stationid']);
		$html_edit_station = '<div id="editStationDiv">' . $html_edit_station . '</div>';
		$html_edit_station = rs_construct_option_item($html_edit_station);
		$hasoptions = true;
	}
	
	if ($rspermissions['delete'] OR 
			($rspermissions['delete_own'] AND $vbulletin->userinfo['userid'] == $station['addedby'])) {
		$html_delete_station = construct_phrase($vbphrase['rs_delete_station'], $station['stationid']);
		$html_delete_station = '<div id="deleteStationDiv">' . $html_delete_station . '</div>';
		$html_delete_station = rs_construct_option_item($html_delete_station);
		$hasoptions = true;
	}
	
	if ($rspermissions['favorites']) {
		$html_add_favorite = rs_construct_favorite_link($station['stationid']);
		$html_add_favorite = '<div id="addFavoriteDiv">' . $html_add_favorite . '</div>';
		$html_add_favorite = rs_construct_option_item($html_add_favorite);
		$hasoptions = true;
	}
	
	if ($rspermissions['report']) {
		$html_report_station = construct_phrase($vbphrase['rs_report_station'], $station['stationid']);
		$html_report_station = '<div id="reportStationDiv">' . $html_report_station . '</div>';
		$html_report_station = rs_construct_option_item($html_report_station);
		$hasoptions = true;
	}
	
	if ($hasoptions) {
		eval('$html_station_options = "' . fetch_template('RADIOSTATIONS_STATION_OPTIONS') . '";');
		
		return $html_station_options;
	}
	
	return '';
}

function rs_construct_station_table($stationid) {
	global $vbulletin, $vbphrase, $stylevar, $rspermissions, $default_player_size, $default_rp_size, $default_quick_size;
	
	if (empty($stationid)) {
		return '';
	}
	
	// lets place the last played station update here, no other place to
	rs_update_last_played($vbulletin->userinfo['userid'], $stationid);
	
	// carry on
	$station = rs_get_station($stationid);
	
	$html_station_info = rs_construct_station_info($station);
	
	$html_station_options = rs_construct_station_options($station);
	
	$html_url          = htmlentities($station['url']);
	
	$html_player_window_link = construct_phrase($vbphrase['rs_click_to_open_bigger_player'], $stationid);
	
	// get right player
	if ($station['playerid'] == 1) { //it's Real Player
		$html_width  = $default_rp_size[0];
		$html_height = $default_rp_size[1];
		eval('$html_player = "' . fetch_template('RADIOSTATIONS_PLAYER_REAL_PLAYER') . '";');
	} else if ($station['playerid'] == 2) { //it's quicktime
		$html_width  = $default_quick_size[0];
		$html_height = $default_quick_size[1];
		eval('$html_player = "' . fetch_template('RADIOSTATIONS_PLAYER_QUICKTIME') . '";');
	} else {
		$html_width  = $default_player_size[0];
		$html_height = $default_player_size[1];
		eval('$html_player = "' . fetch_template('RADIOSTATIONS_PLAYER') . '";');
	}
	
	eval('$html_station = "' . fetch_template('RADIOSTATIONS_STATION_TABLE') . '";');
	
	return $html_station;
}

function rs_get_station($stationid) {
	global $db;
	$results = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "radiostation
									WHERE stationid = " . $stationid);
	return $results;
}

function rs_construct_station_link($station) {
	return '<strong><a href="javascript:changeStation('. $station['stationid'] .')">'. htmlentities($station['name']) .'</a></strong>';
}

?>